﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Pendelzugsteuerung
{

    delegate void SetTextCallback(string text);
    delegate void BottonOnCall();
    delegate int GetWarteZeitCallback();
    delegate void StarteTimerPendelzugCall();


    public partial class Form1 : Form
    {
        #region Initalisierung

        private enum Position {Links,nachLinks,nachRechts,Rechts};
        private enum OnlineStatus { nichtVerbunden,Offline,Online};

        Image g_PicLok;
        Image g_PicLokNachLinks;
        Image g_PicLokNachRechts;
        Image g_PicSucheCom;

        string g_ArduinoCom;

        int g_WarteZeit;

        OnlineStatus g_ArduinoOnlineStatus;

        int[] g_WarteZeiten = { 5, 10, 15, 30, 60, 120, 180 };

        Random g_Zufall = new Random();

        public Form1(string[] args)
        {
            InitializeComponent();

            LoadLokPics();

            pictureBox_Suchen.Image = g_PicSucheCom;
            panel_Suche.Location = new Point(0, 12);

            if (args.Contains("/debug"))
            {
                this.Width = 1024;
                panel_Debug.Location = new Point(800, 24);
            }
            else
            {
                panel_Debug.Visible = false;
            }

            panel_PendelzugZeit.Visible = false;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Arduino.PortName = Properties.Settings.Default.ComPort;
            g_ArduinoCom = Arduino.PortName;

            ComPortCheck();

            switch (g_ArduinoOnlineStatus)
            {
                case OnlineStatus.nichtVerbunden:
                case OnlineStatus.Offline:
                    timer_ComSearch.Enabled = true;
                    timer_OnlineTest.Enabled = false;
                    break;
                case OnlineStatus.Online:
                    timer_ComSearch.Enabled = false;
                    timer_OnlineTest.Enabled = true;
                    panel_Suche.Visible = false;
                    panel_Suche.Enabled = false;
                    break;
            }

        }

        private void LoadLokPics()
        {
            g_PicLok = Image.FromFile(@"Pic\Zug_stehen.png");
            g_PicLokNachLinks = Image.FromFile(@"Pic\Zug_nachLinks.gif");
            g_PicLokNachRechts = Image.FromFile(@"Pic\Zug_nachRechts.gif");
            g_PicSucheCom = Image.FromFile(@"Pic\VerbindungSuchen.gif");
        }

        #endregion

        #region Buttons

        private void button_start_Click(object sender, EventArgs e)
        {
            Arduino.Write("S");
            button_start.Enabled = false;
        }

        private void checkBox_Pendelzug_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox_Pendelzug.Checked)
            {
                panel_PendelzugZeit.Visible = true;
                PendelzugAn();
            }
            else
            {
                panel_PendelzugZeit.Visible = false;
                timer_Pendelzug.Enabled = false;
                
            }

        }

        #endregion

        #region Daten Empfangen

        private void Arduino_DataReceived(object sender, System.IO.Ports.SerialDataReceivedEventArgs e)
        {
            int n_Read = Arduino.ReadChar();

            SetText(n_Read + " -> " + Convert.ToChar(n_Read)+ "\r\n");
             
            switch (n_Read)
            {
                case '1':
                    SetLokPic(Position.Links);
                    BottonOn();
                    if (checkBox_Pendelzug.Checked)
                    {
                        PendelzugAn();
                    }
                    break;
                case '2':
                    SetLokPic(Position.nachLinks);
                    break;
                case '3':
                    SetLokPic(Position.nachRechts);
                    break;
                case '4':
                    SetLokPic(Position.Rechts);
                    BottonOn();
                    if (checkBox_Pendelzug.Checked)
                    {
                        PendelzugAn();
                    }
                    break;
                default:
                    break;
            }

            string n_Rest = Arduino.ReadExisting();
            if (n_Rest != "")
            {
                SetText("Resttext: " + n_Rest + "\r\n");
            }
        }


        #endregion

        #region Timer

        private void timer_OnlineTest_Tick(object sender, EventArgs e)
        {
            if (!Arduino.IsOpen)
            {
                Arduino.Close();
                toolStripStatusLabel_Com.Text = "Verbindung : Offline";
                timer_OnlineTest.Enabled = false;
                timer_ComSearch.Enabled = true;
                panel_Suche.Enabled = true;
                panel_Suche.Visible = true;
            }
        }

        private void timer_ComSearch_Tick(object sender, EventArgs e)
        {
            ComPortCheck();

            switch (g_ArduinoOnlineStatus)
            {
                case OnlineStatus.nichtVerbunden:
                case OnlineStatus.Offline:
                    break;
                case OnlineStatus.Online:
                    timer_ComSearch.Enabled = false;
                    timer_OnlineTest.Enabled = true;
                    panel_Suche.Enabled = false;
                    panel_Suche.Visible = false;
                    break;
            }

        }


        private void timer_Pendelzug_Tick(object sender, EventArgs e)
        {
            timer_Pendelzug.Stop();
            Arduino.Write("S");
            button_start.Enabled = false;
        }


        private void timer_ShowWarteZeit_Tick(object sender, EventArgs e)
        {
            progressBar_Wartezeit.Value--;
            if (progressBar_Wartezeit.Value == 0)
            {
                timer_ShowWarteZeit.Enabled = false;
            }
        }

        private void ComPortCheck()
        {
            string[] n_Coms = System.IO.Ports.SerialPort.GetPortNames();

            bool n_test = n_Coms.Contains(g_ArduinoCom);
            
            if (n_Coms.Contains(g_ArduinoCom))
            {
                try
                {
                    Arduino.Open();

                    if (Arduino.IsOpen)
                    {
                        toolStripStatusLabel_Com.Text = "Verbindung : Online";
                        Arduino.Write("G");
                        timer_OnlineTest.Enabled = true;
                        g_ArduinoOnlineStatus = OnlineStatus.Online;
                    }
                    else
                    {
                        toolStripStatusLabel_Com.Text = "Verbindung : Offline";
                        g_ArduinoOnlineStatus = OnlineStatus.Offline;
                    }

                }
                catch( System.IO.IOException n_Error)
                {
                    toolStripStatusLabel_Com.Text = "Verbindung : nicht angeschlossen";
                    g_ArduinoOnlineStatus = OnlineStatus.nichtVerbunden;
                }
                catch (Exception n_Error)
                {

                    throw;
                }

            }
            else
            {
                toolStripStatusLabel_Com.Text = "Verbindung : nicht angeschlossen";
                g_ArduinoOnlineStatus = OnlineStatus.nichtVerbunden;
            }
        }


        #endregion


        #region Delegates

        private void SetText(string text)
        {
            if (this.textBox_empfangen.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(SetText);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                if (panel_Debug.Visible  == true)
                {
                    this.textBox_empfangen.Text += text;
                }
            }
        }

        private void BottonOn()
        {
            if (this.button_start.InvokeRequired)
            {
                BottonOnCall d = new BottonOnCall(BottonOn);
                this.Invoke(d);
            }
            else
            {
                this.button_start.Enabled = true;
            }
        }

        private int GetWarteZeit()
        {
            if (this.trackBar_WarteZeit.InvokeRequired)
            {
                GetWarteZeitCallback d = new GetWarteZeitCallback(GetWarteZeit);
                return (int)this.Invoke(d);
            }
            else
            {
                return trackBar_WarteZeit.Value;
            }

          
        }

        private void SetLokPic(Position n_Pos)
        {
            switch (n_Pos)
            {
                case Position.Links:
                    pictureBox_Links.Image = g_PicLok;
                    pictureBox_Mittel.Image = null;
                    pictureBox_Rechts.Image = null;
                    break;
                case Position.nachLinks:
                    pictureBox_Links.Image = null;
                    pictureBox_Mittel.Image = g_PicLokNachLinks;
                    pictureBox_Rechts.Image = null;
                    break;
                case Position.nachRechts:
                    pictureBox_Links.Image = null;
                    pictureBox_Mittel.Image = g_PicLokNachRechts;
                    pictureBox_Rechts.Image = null;
                    break;
                case Position.Rechts:
                    pictureBox_Links.Image = null;
                    pictureBox_Mittel.Image = null;
                    pictureBox_Rechts.Image = g_PicLok;
                    break;
                default:
                    pictureBox_Links.Image = null;
                    pictureBox_Mittel.Image = null;
                    pictureBox_Rechts.Image = null;
                    break;
            }

        }

        private void StartePendelzugTimer()
        {
            if (this.label1.InvokeRequired)
            {
                StarteTimerPendelzugCall  d = new StarteTimerPendelzugCall(StartePendelzugTimer);
                this.Invoke(d);
            }
            else
            {
                this.timer_Pendelzug.Enabled = true;
                progressBar_Wartezeit.Maximum = g_WarteZeit;
                progressBar_Wartezeit.Value = g_WarteZeit;
                this.timer_ShowWarteZeit.Enabled = true;
            }
        }

        #endregion

        #region Tools

        void PendelzugAn()
        {
            int n_WertLesen = GetWarteZeit();
            int n_MaxZeit = g_WarteZeiten[n_WertLesen];

            int n_WarteZeit = g_Zufall.Next(1, n_MaxZeit+1);
            g_WarteZeit = n_WarteZeit;
            int n_WarteZeitMill = n_WarteZeit * 1000;

            SetText("Warte: " + n_WarteZeit + " | Lesewert: "+n_WertLesen +" | Max: "+n_MaxZeit +" | Millisec: " +n_WarteZeitMill  +"\r\n");
            timer_Pendelzug.Interval = n_WarteZeitMill;
           
            StartePendelzugTimer();
        }



        #endregion

    }
}
