/*
 * PINZUORDNUNG V2:
 * 
 * Pos Links    D2                       D7/B   D8/C                                 D-Sub
 * Pos Rechts   D3                      Motor1 Motor2 Richtung                     1 2 3 4 5
 * Taster       D4                        0      0      Stop                        6 7 8 9 
 * Motor Links  D7                        1      0      nach Links
 * Motor Rechts D8                        0      1      nach Rechts
 * Speed        D9                        1      1      Stop
 * 
 *   
 *   Leitung X (Pin Arduino) (Pin D-Sub) (Kabel Farbe Strecke)
 *   
 *                                                    B (D7) (7) (rot)                                D (D3)(9)(gelb)
 *   |---------------------------------------------------------------------------------------------- ----------------|    +   -
 *   |------------------------------ --------------------------------------------------------------------------------|    -   +
 *            A (D2)(6)(grau)                                                        C (D8)(8)(blau)                      <- ->
 *   
 *   
 */

#include <PWM.h>

#define PosLinks 2
#define PosRechts 3
#define Speed 9
#define MotorLinks 7
#define MotorRechts 8
#define Taster 4

#define MinSpeed 130
#define MaxSpeed 200
#define PosTest 100
#define VerzoegerungGas 100
#define VerzoegerungBremsen 20
#define VerzoegerungBremsenKurz 4
#define VerzoegerungTaste 500



enum aktPos {unbekant,links,rechts};
enum Fahren {halt,nachLinks,nachRechts};
enum Gas {stay,beschleunigen,bremsen,stoppen};
enum TasterStatus {nichts,kurz,aus};
enum PosPC {PClinks,PCnachlinks,PCnachrechts,PCrechts};

aktPos g_Pos = unbekant;
Fahren g_Fahren = halt;
Gas g_Gas = stay;
TasterStatus g_Taste = nichts;
PosPC g_PosPC = PCrechts;


int g_Speed = 0;
bool g_Auto = false;

char g_Lesen = ' ';

int32_t g_Ausgabefrequenz = 32000;  // PWM Frequenz (ESU LokPilot hat 20 / 40 kHz // Velmo 32kHz)

unsigned long g_alteZeit = 0;
unsigned long g_alteZeitTaste = 0;
unsigned long g_alteZeitPause = 0;
unsigned long g_Verzoegerung = 0;

void setup() 
  {
    Serial.begin(9600);
    
    pinMode(PosLinks,INPUT_PULLUP);
    pinMode(PosRechts,INPUT_PULLUP);
    pinMode(Speed,OUTPUT);
    pinMode(MotorLinks,OUTPUT);
    pinMode(MotorRechts,OUTPUT);
    pinMode(Taster,INPUT_PULLUP);
  
    InitTimersSafe(); 
    bool n_FreqSet = SetPinFrequencySafe(Speed, g_Ausgabefrequenz);
  
    //Fahrzeug in Startposition bringen
    SuchePos();
    if(g_Pos==unbekant)
    {
      g_Taste = aus;
      StartennachRechts();
    }
  
    Serial.print("R");
  }

void loop() {
// 1. Taster abfragen
    if(g_Taste!=aus)
    {
      Taste();
    }

    if(g_Gas!=stay)
    {
      SetSpeed();
    }

}

void serialEvent() 
  {
      if(Serial.available())
      {
        g_Lesen = (char)Serial.read();
      }
    
      switch(g_Lesen)
      {
        case 'S':
            if(g_Pos==rechts)
              {
                //ToLinks();
                StartennachLinks();
              }
            else
              {
                //ToRechts();
                StartennachRechts();
              }
            break;
        case 'G':
            Serial.print(g_PosPC+1);
            break;
        default:
            break;
      }
  }


void Taste()
  {
    int n_Start = digitalRead(Taster);
    unsigned long n_aktZeitTaste = millis();
      
      if(n_Start==0)
      {
          switch(g_Taste){
          case nichts:
            if(g_Auto==false)
            {
              g_Taste=kurz;
              g_alteZeitTaste = n_aktZeitTaste;
            }
            else
            {
              g_Auto = false;
            }
          break;
          case kurz:
            if (n_aktZeitTaste - g_alteZeitTaste >= VerzoegerungTaste) 
              {
                // Taste lang gedrückt -> dauer Pendelbetrieb
                g_Auto = true;
                g_Taste = aus;
                Starten();
              }
          break;
          default:
          break;
          }
      }
      else
      {
        if(g_Taste==kurz && n_aktZeitTaste - g_alteZeitTaste >= VerzoegerungTaste)
        {
          // Taste kurz gedrückt
          g_Taste = aus;
          Starten();
        }
      }
  }


void SuchePos()
  {
    // Teste auf Pos Links
    pwmWrite(Speed,PosTest);
    SetMotor(nachLinks);

    int n_aktPosRead = digitalRead(PosLinks);

    if(n_aktPosRead==LOW)
    {
      //Lok steht links
      g_Pos = links;
      g_PosPC = PClinks;
    }
    else
    {
      SetMotor(nachRechts);
      n_aktPosRead = digitalRead(PosLinks);
      if(n_aktPosRead==LOW)
      {
          //Lok steht rechts
          g_Pos = rechts;
          g_PosPC = PCrechts;
      }
    }
    pwmWrite(Speed,0);
    SetMotor(halt);
  }

void SetMotor(Fahren n_Fahren)
  {
    switch(n_Fahren)
    {
      case nachLinks:
        digitalWrite(MotorLinks,HIGH);
        digitalWrite(MotorRechts,LOW);
        break;
      case nachRechts:
        digitalWrite(MotorLinks,LOW);
        digitalWrite(MotorRechts,HIGH);
        break;
      case halt:
        digitalWrite(MotorLinks,LOW);
        digitalWrite(MotorRechts,LOW);
        break;
    }
  }


void Starten()
  {
    if(g_Pos==links)
    {
      StartennachRechts();
    }
    else
    {
      StartennachLinks();
    }
  }

void AnkommenLinks()
  {
    detachInterrupt(digitalPinToInterrupt(PosLinks));
    g_Gas = bremsen;
    g_Verzoegerung = VerzoegerungBremsen;
    g_Pos = links;
    g_PosPC = PClinks;
  }

void AnkommenRechts()
  {
    detachInterrupt(digitalPinToInterrupt(PosRechts));
    //g_Gas = stoppen;
    g_Gas = bremsen;
    g_Verzoegerung = VerzoegerungBremsenKurz;
    g_Pos = rechts;
    g_PosPC = PCrechts;
  }

void StartennachRechts()
{
      g_Fahren = nachRechts;
      g_Gas = beschleunigen;
      g_Verzoegerung = VerzoegerungGas;
      g_Speed = MinSpeed;
      g_Taste = aus;
      g_Pos = unbekant;
      g_PosPC = PCnachrechts;
      SetMotor(nachRechts);
      //attachInterrupt(digitalPinToInterrupt(PosRechts),AnkommenRechts,FALLING);
      attachInterrupt(digitalPinToInterrupt(PosRechts),AnkommenRechts,LOW);
      Serial.print(g_PosPC+1);
}

void StartennachLinks()
{
      g_Fahren = nachLinks;
      g_Gas = beschleunigen;
      g_Verzoegerung = VerzoegerungGas;
      g_Speed = MinSpeed;
      g_Taste = aus;
      g_Pos = unbekant;
      g_PosPC = PCnachlinks;
      SetMotor(nachLinks);
      //attachInterrupt(digitalPinToInterrupt(PosLinks),AnkommenLinks,FALLING);
      attachInterrupt(digitalPinToInterrupt(PosLinks),AnkommenLinks,LOW);
      Serial.print(g_PosPC+1);
}


void SetSpeed()
  {
    unsigned long n_aktZeit = millis();
    if (n_aktZeit - g_alteZeit >= g_Verzoegerung) 
      {
        g_alteZeit = n_aktZeit;
        switch (g_Gas) 
        {
          case beschleunigen:
            g_Speed++;
            if(g_Speed>=MaxSpeed)
            {
              g_Gas = stay;
            }
            break;
          case bremsen:
            g_Speed--;
            if(g_Speed<=MinSpeed)
            {
              g_Gas = stoppen;
            }
            break;
          case stoppen:
            g_Speed=0;
            g_Gas = stay;
            g_Taste = nichts;
            Serial.print(g_PosPC+1);
            if(g_Auto==true)
            {
                          
            }
            break;
          default:         
          break;
        }
        pwmWrite(Speed,g_Speed);
      }
  }
    

